// landscape.pov
// Copyright Charles E V Pegge 2004

// sunlight and atmospheric conditions
 #declare sunshine=1.4; // 1 to 2
 #declare sunset=0;
 #declare dawn=0;  
 #declare night=0;
 #declare infinite_sky=1;
 #declare sky_gradation=0.74; // 0 to 1 typ 0.75..0.8
 #declare clouds=0.45; // 0 to 1
 #declare fog_transparency=0.78; // 0.65; //0.80; // ,77
 #declare fog_distance=70; 

// dry land
 #declare flat_land=1; // 0 or 1
 #declare fine_grassland=0; // 0 or 1
 #declare sandy_ground=1; // 0 or 1
 #declare beach=0; // 0 or 1
 
// water

 #declare sea=0; //#declare sea_floor=1; // 0 or 1
 #declare millpond=0; // 0 or 1
 #declare choppy_waves=0; // 0 or 1
 #declare waves3d=0; // 0 or 1
 #declare water_clarity=0.8; // 0.8 typ

// dome components
   
 #declare ht=3.1; // 0 to 4
 #declare ds=40;
 #declare gscale=6; // dome size 2.5 to 20
 #declare geodesic_shell=1; // 0 or 1
 #declare geodesic_core=0; // 0 or 1
 #declare boulders=0; // 0 or 1
  
// scenery items
 
 #declare stone_tower=0; // 0 or 1 or 2
 #declare boats=0;
 #declare forground=0; //0 or 1  beachy rocks
 #declare middle_land=1; // 0 or 1
 #declare middle_hills=1; // 0 or 1
 #declare dunes=1; // 0 or 0 

 #declare far_vegetation=1; // 0 or 1
 #declare trees=0; // 0 or 1
 #declare wide_trees=0; // 0 or 1
 
 #declare cone_men=0; // 0 or 1 
 #declare poser_figures=0; // 0 or 1
  #declare horses=1; // 0 or 1
 #declare RBFuller=1; // 0 or 1
 
 #declare vehicles=1; // 0 or 1 
  #declare dymaxion_cars=1; // 0 or 1 

 #declare tomtrees=0; // 0 or 1
 #declare cacti=1; // 0 or 1
 #declare undulating_ground=1; // 0 or 1 for pebbles & small plants
 #declare pebbles=1; // 0 or 1

 #declare small_plants=1; // 0 or 1
  #declare small_spiky_plants=1; // 0 or 1
  #declare small_cacti=1; // 0 or 1
  #declare small_flowering_plants=0; // 0 or 1
// other
 #declare focal=0.0; // .1 .4 1.5

#include "colors.inc"
#include "functions.inc"

camera{
// location <0, 40000, -20> look_at < 0, 1, ds >
// location <0, 10000, -20> look_at < 0, 1, ds >
// location <0, 5000, -20> look_at < 0, 1, ds >
// location <0, 1000, -20> look_at < 0, 1, 150 >
// location <0, 100, -20> look_at < 0, 1, 150 >
// location <0, 10, ds-30> look_at < 0, 1, ds >
location <0, 4, -15> look_at < 0, 4, ds >
 angle 35 //zoom 16 norm 30 wide angle 60
 #if (focal>0) 
  focal_point <0, 0, ds>   
  aperture  focal // 0.4     // a nice compromise
  //  blur_samples 4       // fewer samples, faster to render
  blur_ysamples 20      // more samples, higher quality image
 #end
} 



#if (sunset>0)
 #declare cloud_light=0.15;
 light_source{ <5,1,-5>*10000 color rgb sunshine*1.2*<1,0.7,0.4> }  // sunset
#else
 #if (dawn>0)  
  #declare cloud_light=0.35;
  light_source{ <3,3,3>*10000 color rgb sunshine*2*<1,1,1> }     // bright
  light_source{ <5,5,-5>*1000 color rgb sunshine*.5*<0.35,0.0,0.5> }     // bright
 #end
 #if (night>0)  
  #declare cloud_light=0.35;
  light_source{ <3,3,3>*10000 color rgb sunshine*.75*<1,1,1> }     // bright
  light_source{ <5,5,-5>*1000 color rgb sunshine*.25*<0.35,0.0,0.5> }     // bright
 #end
 #if (night+dawn=0)
  #declare cloud_light=0.35;
  light_source{ <5,5,-5>*1000 color rgb sunshine*<1,1,1> }     // bright
 #end
#end         



#if (tomtrees=1)
 #include "tomtree/PALM straight.inc"
 #include "tomtree/TOMTREE.inc"
 object { TREE scale 10 translate <7.3,0,9> }
 object { TREE rotate 90*y scale 8 translate <17.5,0,120> }
 object { TREE rotate 45*y scale 10 translate <23.5,0,120> }
#end

#if (poser_figures=1)
 #include "poser figures\man waiting_pov.inc"
 #include "poser figures\woman waiting_pov.inc"
 //object{ Woman_waiting scale 10 rotate -20*y translate <0,-0.13,-0.5> }
 object{ Woman_waiting scale 4.5 rotate -20*y translate <4.0,-0.1,2.5> }
 // object{ Man_waiting scale 4.5 rotate 180*y translate <5.7,0.1,ds-5> }
 object{ Man_waiting scale 4.5 rotate 200*y translate <20,-0.0,119> }
 #if (horses>0)
  #include "poser figures\horse standing.inc"
  object{ Horse_standing scale 4.5 rotate 90*y translate <-36.0,-0.1,150> }
 #end
#end

#if (vehicles>0)
 #if (dymaxion_cars>0)
  #include "dymaxion_car.inc"
 #end
#end // vehicles

#if (boulders=1)
 #include "boulders.inc"
// object { rotunda_wall scale gscale/5 translate <0,-0.3,ds>  }
 object { rotunda_wall scale gscale/5 translate <25,-0.3,99>  }
#end


#if (wide_trees=1)
 #include "wide trees.inc"
 object { wide_tree translate <-17,0,50> }
 object { litter translate <0,0,40> }
 object { wide_tree rotate 5*y translate <10,0,15> }
 object { litter rotate 5*y translate <10,0,15> }
 object { litter translate 10*z }
#end

// #include "profiled panels"

#if (cone_men=1)
 #include "cone men.inc"
#end

#if (trees>0)
 #include "trees.inc"
#end
 
#if (boats>0)
 #include "boats.inc"
#end 


#if (geodesic_shell+geodesic_core>0)
 #include "geodesic buildings.inc"
#end

#if (boats>0)
 #include "boats.inc"
#end



#if (stone_tower>0)
 #include "stone tower.inc"
#end  

#include "distant landscape.inc"
  


#if (sea>0)
 #include "waters.inc"
#end  // of sea


#include "stdinc.inc"

#if (dunes=1)
 #declare dunes1=
 isosurface {
 function { y
 -(f_noise3d(x*0.2,0,z*0.2)*1.25)
 }
 open
 // max_gradient 1
 contained_by { sphere {0,20}}
  texture {
   pigment { colour rgb <.60,.55,.50> }
     normal {
      average 
       //crackle 1 scale 1
       //waves 0.16
       //frequency 3000.0
       //scale 600.0   // 100
       //wrinkles 0.5 sclae 1 
       //ripples 0.2 scale 1
       normal_map {
       [2  bumps 1.5 scale 0.02 ]
       [1  bumps 0.5 scale 0.05 ]
       [1  bumps 0.5 scale 0.10 ]
       [1  bumps 0.5 scale 0.20 ]
       //[4  bumps 0.5 scale 0.40 ]
       //[2  bumps 0.5 scale 0.80 ]
        } // normal_map
      } // normal
    } // texture
    finish { ambient 0.2 }
    scale 2*y
  }
  object { dunes1 translate <0,-1.5,ds> }
#end // dunes

/////////////////////////////////
#if (undulating_ground>0)
 #declare undulating_sand=
 isosurface {
  function { y 
  - (f_snoise3d(x/10, 0, z/2)*0.7) // was x/7 z/2 *0.5
  - (f_snoise3d(x, 0, z)*0.05)
  }  
  threshold 0
  max_gradient 1.1
  contained_by {box {<-100,-3,-100>, < 100, 1, 1000>}}
  /*	texture {
  pigment {color rgb < 1, 0.9, 0.65>}
  normal {granite bump_size 0.1 scale 0.01}
  }*/
  texture {
   pigment {color rgb < 1.0, 1.0, 0.8>}   // was 1 .9 .65
   normal { average // {granite 0.2 scale 0.7}  // was .2 .02
   normal_map {
   [1  bumps 1.0 scale 0.001 ]
   [1  bumps 1.0 scale 0.002 ]
   [1  bumps 1.0 scale 0.005 ]
   //[1  bumps 1.0 scale 0.01 ]
   //[1  bumps 0.2 scale 0.02 ]
   //[1  bumps 0.2 scale 0.05 ]
   //[1  bumps 0.1 scale 0.10 ]
   //[1  bumps 0.5 scale 0.20 ]
   //[1  bumps 0.5 scale 0.40 ]
   //[1  bumps 0.5 scale 0.80 ]
   } // normal
   } // normal
   finish {
    brilliance 1.8 // was 1.6
    specular 0.3
   } // finish
  } // texture
 } // isosurface


 #declare Ground=
 object { undulating_sand }
 
 object {Ground}
#end // undulating_ground


// setup for pebbles and cacti
#include "arrays.inc"
#declare RS = seed(464786);
                
                
#if (pebbles>0)
 #include "pebbles.inc"
#end

#if (cacti>0)
#include "cacti.inc"
#end


#if (flat_land>0)

#declare undulations=
 isosurface {
 function { y
 //-(f_wrinkles(x*0.2,0,z*0.2)*1)
 -(f_wrinkles(x*0.5,0,z*0.5)*1)
 //-(f_wrinkles(x*1.0,0,z*1.0)*1)
 }
 open
 // max_gradient 1
 contained_by { sphere {0,6000}}
}

 #if (beach>0)
 union {
  object { undulations scale <1,1,1> translate -.7*y rotate 0.5*z
   pigment { colour rgb <.10,.45,.0> }
   finish { ambient 0.0 phong 0.5 }
   }
   cylinder { <0,-0.1,0>,<0,-0.2,0>,6000 }
  #else
   cylinder { <0,-0.1,0>,<0,-0.2,0>,6000 
  #end
 //plane { y, -0.1 }
   texture {
    #if (fine_grassland>0)
     pigment { colour rgb <0.2,0.70,0.10> } 
    #end
    #if (sandy_ground>0)
     pigment { colour rgb <.60,.55,.50> }
    #end
    normal {
     average 
      //crackle 1 scale 1
      //waves 0.16
      //frequency 3000.0
      //scale 600.0   // 100
      //wrinkles 0.5 sclae 1 
      //ripples 0.2 scale 1
      normal_map {
      [2  bumps 1.5 scale 0.02 ]
      [1  bumps 0.5 scale 0.05 ]
      [1  bumps 0.5 scale 0.10 ]
      [1  bumps 0.5 scale 0.20 ]
       } // normal_map
     } // normal
   } // texture
   finish { ambient 0.5 }
} // plane


#end // flat_land

#if (infinite_sky>0)   
sky_sphere {
 pigment {
 gradient y
 color_map {
 //[ 0,0.25  color rgb < 0.0, 0.8, 1.0 > color rgb < 0.0, 0.1, 0.7 > ]
 [ 0,1-sky_gradation  color rgb < 0.0, 0.8, 1.0 > color rgb < 0.0, 0.0, 0.7 > ]
 }
 scale 2
 translate y*-0.01
 }
}
#end


#if (night>0)
#end


// several layers of cloud
#if (clouds>0) 
 #include "clouds.inc"
#end 
 
// for murky conditions

  fog {
    fog_type 2
    fog_offset 0
    fog_alt 20
    turbulence 0.9
    turb_depth 0.1
    color rgbt<0.8, 0.8, 0.8, fog_transparency >
    distance fog_distance
   }


 


